package net.jcip.examples;

import java.util.logging.*;

/**
 * UEHLogger
 * <p/>
 * Procedura obsugi UncaughtExceptionHandler zapisujca informacje do dziennika aplikacji.
 *
 * @author Brian Goetz and Tim Peierls
 */
public class UEHLogger implements Thread.UncaughtExceptionHandler {
    public void uncaughtException(Thread t, Throwable e) {
        Logger logger = Logger.getAnonymousLogger();
        logger.log(Level.SEVERE, "Wtek wstrzymany przez wyjtek: " + t.getName(), e);
    }
}
