package net.jcip.examples;

import java.util.concurrent.*;
import static net.jcip.examples.LaunderThrowable.launderThrowable;

/**
 * TimedRun
 * <p/>
 * Anulowanie zadania za pomoc obiektu Future
 *
 * @author Brian Goetz i Tim Peierls
 */
public class TimedRun {
    private static final ExecutorService taskExec = Executors.newCachedThreadPool();

    public static void timedRun(Runnable r,
                                long timeout, TimeUnit unit)
            throws InterruptedException {
        Future<?> task = taskExec.submit(r);
        try {
            task.get(timeout, unit);
        } catch (TimeoutException e) {
            // Zadanie zostanie anulowane poniej.
        } catch (ExecutionException e) {
            // Wyjtek zgszony w zadaniu, zgo go ponownie.
            throw launderThrowable(e.getCause());
        } finally {
            // Nie ma znaczenia, jeli zadanie si zakoczyo.
            task.cancel(true); // Przerywa zadanie w toku.
        }
    }
}
