package net.jcip.examples;

import java.util.concurrent.locks.*;

import net.jcip.annotations.*;

/**
 * SemaphoreOnLock
 * <p/>
 * Semafor zliczajcy zaimplementowany przy uyciu obiektu Lock
 * (nie jest to rzeczywisty sposb implementacji semafora java.util.concurrent.Semaphore).
 *
 * @author Brian Goetz i Tim Peierls
 */
@ThreadSafe
public class SemaphoreOnLock {
    private final Lock lock = new ReentrantLock();
    // PREDYKAT WARUNKU: przepustki dostpne (permits > 0)
    private final Condition permitsAvailable = lock.newCondition();
    @GuardedBy("lock") private int permits;

    SemaphoreOnLock(int initialPermits) {
        lock.lock();
        try {
            permits = initialPermits;
        } finally {
            lock.unlock();
        }
    }

    // BLOKUJE DOPKI: przepustki dostpne
    public void acquire() throws InterruptedException {
        lock.lock();
        try {
            while (permits <= 0)
                permitsAvailable.await();
            --permits;
        } finally {
            lock.unlock();
        }
    }

    public void release() {
        lock.lock();
        try {
            ++permits;
            permitsAvailable.signal();
        } finally {
            lock.unlock();
        }
    }
}
