package net.jcip.examples;

import java.util.concurrent.atomic.*;

/**
 * NumberRange
 * <p/>
 * Klasa zakresu liczb, ktra niewystarczajco dobrze chroni niezmiennik.
 *
 * @author Brian Goetz i Tim Peierls
 */

public class NumberRange {
    // NIEZMIENNIK: lower <= upper
    private final AtomicInteger lower = new AtomicInteger(0);
    private final AtomicInteger upper = new AtomicInteger(0);

    public void setLower(int i) {
        // Uwaga -- niebezpieczne sprawd i dziaaj
        if (i > upper.get())
            throw new IllegalArgumentException("nie mog ustawi lower " + i + " > upper");
        lower.set(i);
    }

    public void setUpper(int i) {
        // Uwaga -- niebezpieczne sprawd i dziaaj
        if (i < lower.get())
            throw new IllegalArgumentException("nie mog ustawi upper " + i + " < lower");
        upper.set(i);
    }

    public boolean isInRange(int i) {
        return (i >= lower.get() && i <= upper.get());
    }
}

