package net.jcip.examples;

import java.util.concurrent.*;

/**
 * NoncancelableTask
 * <p/>
 * Zadanie bez moliwoci anulowania, ktre przywraca status przerwania przed swym zakoczeniem.
 *
 * @author Brian Goetz i Tim Peierls
 */
public class NoncancelableTask {
    public Task getNextTask(BlockingQueue<Task> queue) {
        boolean interrupted = false;
        try {
            while (true) {
                try {
                    return queue.take();
                } catch (InterruptedException e) {
                    interrupted = true;
                    // Ponownie podejmij prb pobrania danych.
                }
            }
        } finally {
            if (interrupted)
                Thread.currentThread().interrupt();
        }
    }

    interface Task {
    }
}
