package net.jcip.examples;

/**
 * StaticUtilities
 *
 * @author Brian Goetz i Tim Peierls
 */
public class LaunderThrowable {

    /**
     * Ograniczenie nieweryfikowanych bdw Throwable do wyjtkw RuntimeException.
     * <p/>
     * Jeli Throwable to Error, zgo go; jeli to
     * RuntimeException, zwr go, w przeciwnym razie zgo IllegalStateException.
     */
    public static RuntimeException launderThrowable(Throwable t) {
        if (t instanceof RuntimeException)
            return (RuntimeException) t;
        else if (t instanceof Error)
            throw (Error) t;
        else
            throw new IllegalStateException("Nie nieweryfikowalny", t);
    }
}
