package net.jcip.examples;

import java.util.*;
import java.util.concurrent.*;

/**
 * GuiExecutor
 * <p/>
 * Klasa szkieletu Executor wykorzystujca SwingUtilities.
 *
 * @author Brian Goetz i Tim Peierls
 */
public class GuiExecutor extends AbstractExecutorService {
    // Singletony maj prywatny konstruktor i publiczn metod fabryczn.
    private static final GuiExecutor instance = new GuiExecutor();

    private GuiExecutor() {
    }

    public static GuiExecutor instance() {
        return instance;
    }

    public void execute(Runnable r) {
        if (SwingUtilities.isEventDispatchThread())
            r.run();
        else
            SwingUtilities.invokeLater(r);
    }

    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit)
            throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    public boolean isShutdown() {
        return false;
    }

    public boolean isTerminated() {
        return false;
    }
}
