package net.jcip.examples;

import net.jcip.annotations.*;

/**
 * DoubleCheckedLocking
 * <p/>
 * Antywzorzec podwjnego sporawdzania blokady.
 *
 * @author Brian Goetz i Tim Peierls
 */
@NotThreadSafe
public class DoubleCheckedLocking {
    private static Resource resource;

    public static Resource getInstance() {
        if (resource == null) {
            synchronized (DoubleCheckedLocking.class) {
                if (resource == null)
                    resource = new Resource();
            }
        }
        return resource;
    }

    static class Resource {

    }
}
