package net.jcip.examples;

import net.jcip.annotations.*;

/**
 * CasCounter
 * <p/>
 * Nieblokujcy licznik stosujcy CAS
 *
 * @author Brian Goetz i Tim Peierls
 */
@ThreadSafe
public class CasCounter {
    private SimulatedCAS value;

    public int getValue() {
        return value.get();
    }

    public int increment() {
        int v;
        do {
            v = value.get();
        } while (v != value.compareAndSwap(v, v + 1));
        return v + 1;
    }
}
