package net.jcip.examples;

import java.util.*;

import net.jcip.annotations.*;

/**
 * BetterVector
 * <p/>
 * Rozszerzenie klasy Vector o metod wstaw jeli brakuje.
 *
 * @author Brian Goetz i Tim Peierls
 */
@ThreadSafe
public class BetterVector <E> extends Vector<E> {
    // W momencie rozszerzania serializowanej klasy powinnimy zmie serialVersionUID.
    static final long serialVersionUID = -3963416950630760754L;

    public synchronized boolean putIfAbsent(E x) {
        boolean absent = !contains(x);
        if (absent)
            add(x);
        return absent;
    }
}
