package net.jcip.annotations;
import java.lang.annotation.*;

/*
 * Copyright (c) 2005 Brian Goetz and Tim Peierls
 * Udostpnione na licencji Creative Commons Attribution License
 *   (http://creativecommons.org/licenses/by/2.5)
 * Oficjalna witryna: http://www.jcip.net
 *
 * Dowolna ponowna publikacja lub praca zalena dystrybuowana w postaci kodu rdowego
 * Musi zawierac powysza informacj o prawach autorskich i licencji.
 */



/**
 * Klasa zawierajca t adnotacj jest bezpieczna wtkowo. Oznacza to, e adna sekwencja dostpu
 * (odczyty i zapisy pl publicznych, wywoania metod publicznych)
 * nie mog doprowadzi do powstania niespjnego stanu niezalenie od uoenia czasowego tych akcji.
 * Do uzyskania odpowiedniego dziaania nie jest te potrzebna adna synchronizacja po stronie 
 * kodu wywoujcego.
 */
@Documented
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface ThreadSafe {
}
