package net.jcip.annotations;
import java.lang.annotation.*;

/*
 * Copyright (c) 2005 Brian Goetz and Tim Peierls
 * Udostpnione na licencji Creative Commons Attribution License
 *   (http://creativecommons.org/licenses/by/2.5)
 * Oficjalna witryna: http://www.jcip.net
 *
 * Dowolna ponowna publikacja lub praca zalena dystrybuowana w postaci kodu rdowego
 * Musi zawierac powysza informacj o prawach autorskich i licencji.
 */


/**
 * Klasa zawierajca t adnotacj jest niezmienna. Oznacza to, e jej stanu nie zmieni
 * kod wywoujcy, co oznacza e:
 * <ul>
 * <li> wszystkie pola publiczne s typu final, </li>
 * <li> wszystkie publiczne pola referencyjne dotyczc obiektw niezmiennych </li>
 * <li> konstruktory i metody nie udostpniaj adnego wewnetrznego stanu, ktry 
 *      mgby ewentualnie sta si zmienny. </li>
 * </ul>
 * Obiekty niezmienne mog wewntrznie wykorzystywa zmienne stany w celu optymalizacji
 * niektre zmienne stanu mog bywyliczane leniwie, ale kod stosujcy obiekt
 * nie jest w stanie wykry takiej sytuacji ani doprowadzi do zwrcenia innego wyniku.
 * <p>
 * Obiekty niezmienne s bezpieczne wtkowo; moga by publikowane i przekazywane midzy wtkami
 * bez adnej synchronizacji.
 */
@Documented
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface Immutable {
}
