package net.jcip.examples;

import net.jcip.annotations.*;

/**
 * ThreadGate
 * <p/>
 * Brama z moliwoci wielokrotnego zamykania stosujca wait() i notifyAll().
 *
 * @author Brian Goetz i Tim Peierls
 */
@ThreadSafe
public class ThreadGate {
    // PREDYKAT-WARUNKU: otwarte od(n) (isOpen || generation>n)
    @GuardedBy("this") private boolean isOpen;
    @GuardedBy("this") private int generation;

    public synchronized void close() {
        isOpen = false;
    }

    public synchronized void open() {
        ++generation;
        isOpen = true;
        notifyAll();
    }

    // BLOKUJ DOPKI: otwarte od(generacja wejcia)
    public synchronized void await() throws InterruptedException {
        int arrivalGeneration = generation;
        while (!isOpen && arrivalGeneration == generation)
            wait();
    }
}
