package net.jcip.examples;

/**
 * LeftRightDeadlock
 *
 * Prosta blokada wzajemna przez rn kolejno zakadania blokad
 *  
 * @author Brian Goetz i Tim Peierls
 */
public class LeftRightDeadlock {
    private final Object left = new Object();
    private final Object right = new Object();

    public void leftRight() {
        synchronized (left) {
            synchronized (right) {
                doSomething();
            }
        }
    }

    public void rightLeft() {
        synchronized (right) {
            synchronized (left) {
                doSomethingElse();
            }
        }
    }

    void doSomething() {
    }

    void doSomethingElse() {
    }
}
