package net.jcip.examples;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

/**
 * ConnectionDispenser
 * <p/>
 * Uycie ThreadLocal do zapewnienia odosobnienia w wtku.
 *
 * @author Brian Goetz i Tim Peierls
 */
public class ConnectionDispenser {
    static String DB_URL = "jdbc:mysql://localhost/mydatabase";

    private ThreadLocal<Connection> connectionHolder
            = new ThreadLocal<Connection>() {
                public Connection initialValue() {
                    try {
                        return DriverManager.getConnection(DB_URL);
                    } catch (SQLException e) {
                        throw new RuntimeException("Nie mog uzyskac poczenia, e");
                    }
                };
            };

    public Connection getConnection() {
        return connectionHolder.get();
    }
}
