/*
 * Copyright (c) 2005 Brian Goetz and Tim Peierls
 * Udostpnione na licencji Creative Commons Attribution License
 *   (http://creativecommons.org/licenses/by/2.5)
 * Oficjalna witryna: http://www.jcip.net
 *
 * Dowolna ponowna publikacja lub praca zalena dystrybuowana w postaci kodu rdowego
 * Musi zawierac powysza informacj o prawach autorskich i licencji.
 */

package net.jcip.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Pole lub metoda, dla ktrej zastosowano t adnotacj moe by uywana tylko wtedy,
 * gdy uzyska si wskazan blokad, ktra moe by blokad wewntrzn (blok synchronizujcy) lub
 * jawnym obiektem java.util.concurrent.Lock.
 *
 * Argument okrela, ktra blokada chroni pole lub metod:
 * <ul>
 * <li>
 * <code>this</code> : blokada wewntrzna obiektu, ktry zawiera pole lub metod.
 * </li>
 * <li>
 * <code>class-name.this</code> : w klasach wewntrznych naley uszczegowi 'this';
 * <em>class-name.this</em> umoliwia bardziej konkretne wskazanie, o ktr referencj 'this' chodzi
 * </li>
 * <li>
 * <code>itself</code> : tylko dla pl referencyjnych; obiekt, ktrego dotyczy pole.
 * </li>
 * <li>
 * <code>field-name</code> : obiekt blokady, ktrego referencj zawiera pole o nazwie
 * <em>field-name</em>.
 * </li>
 * <li>
 * <code>class-name.field-name</code> : obiekt blokady, ktrego referencj zawiera pole statyczne wskazane
 * przez <em>class-name.field-name</em>.
 * </li>
 * <li>
 * <code>method-name()</code> : obiekt blokady uzyskuje si po wywoaniu wskazanej metody.
 * </li>
 * <li>
 * <code>class-name.class</code> : obiekt Class wskazanej klasy jest obiektem blokady.
 * </li>
 */
@Target({ElementType.FIELD, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface GuardedBy {
    String value();
}
