package net.jcip.examples;

import java.util.concurrent.*;

/**
 * TaskRunnable
 * <p/>
 * Odbudowa przerwania, by nie utraci informacji o nim.
 *
 * @author Brian Goetz i Tim Peierls
 */
public class TaskRunnable implements Runnable {
    BlockingQueue<Task> queue;

    public void run() {
        try {
            processTask(queue.take());
        } catch (InterruptedException e) {
            // odbudowa przerwania
            Thread.currentThread().interrupt();
        }
    }

    void processTask(Task task) {
        // Obsuga zadania.
    }

    interface Task {
    }
}
