package net.jcip.examples;

import java.util.*;
import java.util.regex.*;

import net.jcip.annotations.*;

/**
 * AttributeStore
 * <p/>
 * Przetrzymywanie blokady duej ni jest to konieczne.
 *
 * @author Brian Goetz i Tim Peierls
 */
@ThreadSafe
public class AttributeStore {
    @GuardedBy("this") private final Map<String, String>
            attributes = new HashMap<String, String>();

    public synchronized boolean userLocationMatches(String name,
                                                    String regexp) {
        String key = "users." + name + ".location";
        String location = attributes.get(key);
        if (location == null)
            return false;
        else
            return Pattern.matches(regexp, location);
    }
}
