package net.jcip.examples;

import java.util.concurrent.*;

/**
 * WorkerThread
 * <p/>
 * Szeregowy dostp do kolejki zada.
 *
 * @author Brian Goetz i Tim Peierls
 */

public class WorkerThread extends Thread {
    private final BlockingQueue<Runnable> queue;

    public WorkerThread(BlockingQueue<Runnable> queue) {
        this.queue = queue;
    }

    public void run() {
        while (true) {
            try {
                Runnable task = queue.take();
                task.run();
            } catch (InterruptedException e) {
                break; /* Zapewnia wyczenie wtku. */
            }
        }
    }
}
