package net.jcip.examples;

import java.util.concurrent.*;

/**
 * InterruptBorrowedThread
 * <p/>
 * Harmonogramowanie przerwania poyczonego wtku.
 *
 * @author Brian Goetz i Tim Peierls
 */
public class TimedRun1 {
    private static final ScheduledExecutorService cancelExec = Executors.newScheduledThreadPool(1);

    public static void timedRun(Runnable r,
                                long timeout, TimeUnit unit) {
        final Thread taskThread = Thread.currentThread();
        cancelExec.schedule(new Runnable() {
            public void run() {
                taskThread.interrupt();
            }
        }, timeout, unit);
        r.run();
    }
}
