package net.jcip.examples;

import java.util.concurrent.*;

/**
 * ThreadDeadlock
 * <p/>
 * Zadanie z blokad wzajemn w przypadku zastosowania puli jednowtkowej.
 *
 * @author Brian Goetz i Tim Peierls
 */
public class ThreadDeadlock {
    ExecutorService exec = Executors.newSingleThreadExecutor();

    public class LoadFileTask implements Callable<String> {
        private final String fileName;

        public LoadFileTask(String fileName) {
            this.fileName = fileName;
        }

        public String call() throws Exception {
            // Oto miejsce rzeczywistego odczytu pliku.
            return "";
        }
    }

    public class RenderPageTask implements Callable<String> {
        public String call() throws Exception {
            Future<String> header, footer;
            header = exec.submit(new LoadFileTask("header.html"));
            footer = exec.submit(new LoadFileTask("footer.html"));
            String page = renderBody();
            // Zawiera blokad wzajemn -- zadanie czeka na wykonanie podzada.
            return header.get() + page + footer.get();
        }

        private String renderBody() {
            // Tu znalazby si kod renderujcy stron.
            return "";
        }
    }
}
