package net.jcip.examples;

import java.util.*;

/**
 * SafeVectorHelpers
 * <p/>
 * Zoone operacje na obiekcie Vector uywajce blokowania po stronie klienta
 *
 * @author Brian Goetz i Tim Peierls
 */
public class SafeVectorHelpers {
    public static Object getLast(Vector list) {
        synchronized (list) {
            int lastIndex = list.size() - 1;
            return list.get(lastIndex);
        }
    }

    public static void deleteLast(Vector list) {
        synchronized (list) {
            int lastIndex = list.size() - 1;
            list.remove(lastIndex);
        }
    }
}
