package net.jcip.examples;

import java.util.concurrent.locks.*;

import net.jcip.annotations.*;

/**
 * OneShotLatch
 * <p/>
 * Zatrzask binarny uywajcy klasy AbstractQueuedSynchronizer
 *
 * @author Brian Goetz i Tim Peierls
 */
@ThreadSafe
public class OneShotLatch {
    private final Sync sync = new Sync();

    public void signal() {
        sync.releaseShared(0);
    }

    public void await() throws InterruptedException {
        sync.acquireSharedInterruptibly(0);
    }

    private class Sync extends AbstractQueuedSynchronizer {
        protected int tryAcquireShared(int ignored) {
            // Sukces, jeli zatrzask jest otwarty (state == 1); w przeciwnym razie bd.
            return (getState() == 1) ? 1 : -1;
        }

        protected boolean tryReleaseShared(int ignored) {
            setState(1); // Zatrzask zostaje otwarty.
            return true; // Inne wtki mog rozpocz dziaanie.

        }
    }
}
