package net.jcip.examples;

import net.jcip.annotations.*;

/**
 * BoundedBuffer
 * <p/>
 * Bufor o ograniczonym rozmiarze stosujcy semafory.
 *
 * @author Brian Goetz i Tim Peierls
 */
@ThreadSafe
public class BoundedBuffer <V> extends BaseBoundedBuffer<V> {
    // PREDYKAT WARUNKOWY: niepeny (!isFull())
    // PREDYKAT WARUNKOWY: niepusty (!isEmpty())
    public BoundedBuffer() {
        this(100);
    }

    public BoundedBuffer(int size) {
        super(size);
    }

    // BLOKUJE DOPKI: niepeny
    public synchronized void put(V v) throws InterruptedException {
        while (isFull())
            wait();
        doPut(v);
        notifyAll();
    }

    // BLOKUJE DOPKI: niepusty
    public synchronized V take() throws InterruptedException {
        while (isEmpty())
            wait();
        V v = doTake();
        notifyAll();
        return v;
    }

    // BLOKUJE DOPKI: niepeny
    // Alternatywna wersja put() stosujca powiadamianie warunkowe.
    public synchronized void alternatePut(V v) throws InterruptedException {
        while (isFull())
            wait();
        boolean wasEmpty = isEmpty();
        doPut(v);
        if (wasEmpty)
            notifyAll();
    }
}
