/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionTargeter;
import org.apache.bcel.generic.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructionHandle
implements Serializable {
    private static final long serialVersionUID = -3585254135692924106L;
    InstructionHandle next;
    InstructionHandle prev;
    Instruction instruction;
    protected int i_position = -1;
    private Set<InstructionTargeter> targeters;
    private Map<Object, Object> attributes;
    private static InstructionHandle ih_list = null;

    public final InstructionHandle getNext() {
        return this.next;
    }

    public final InstructionHandle getPrev() {
        return this.prev;
    }

    public final Instruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(Instruction i) {
        if (i == null) {
            throw new ClassGenException("Assigning null to handle");
        }
        if (this.getClass() != BranchHandle.class && i instanceof BranchInstruction) {
            throw new ClassGenException("Assigning branch instruction " + i + " to plain handle");
        }
        if (this.instruction != null) {
            this.instruction.dispose();
        }
        this.instruction = i;
    }

    public Instruction swapInstruction(Instruction i) {
        Instruction oldInstruction = this.instruction;
        this.instruction = i;
        return oldInstruction;
    }

    protected InstructionHandle(Instruction i) {
        this.setInstruction(i);
    }

    static final InstructionHandle getInstructionHandle(Instruction i) {
        if (ih_list == null) {
            return new InstructionHandle(i);
        }
        InstructionHandle ih = ih_list;
        ih_list = ih.next;
        ih.setInstruction(i);
        return ih;
    }

    protected int updatePosition(int offset, int max_offset) {
        this.i_position += offset;
        return 0;
    }

    public int getPosition() {
        return this.i_position;
    }

    void setPosition(int pos) {
        this.i_position = pos;
    }

    protected void addHandle() {
        this.next = ih_list;
        ih_list = this;
    }

    void dispose() {
        this.prev = null;
        this.next = null;
        this.instruction.dispose();
        this.instruction = null;
        this.i_position = -1;
        this.attributes = null;
        this.removeAllTargeters();
        this.addHandle();
    }

    public void removeAllTargeters() {
        if (this.targeters != null) {
            this.targeters.clear();
        }
    }

    public void removeTargeter(InstructionTargeter t) {
        if (this.targeters != null) {
            this.targeters.remove(t);
        }
    }

    public void addTargeter(InstructionTargeter t) {
        if (this.targeters == null) {
            this.targeters = new HashSet<InstructionTargeter>();
        }
        this.targeters.add(t);
    }

    public boolean hasTargeters() {
        return this.targeters != null && this.targeters.size() > 0;
    }

    public InstructionTargeter[] getTargeters() {
        if (!this.hasTargeters()) {
            return new InstructionTargeter[0];
        }
        InstructionTargeter[] t = new InstructionTargeter[this.targeters.size()];
        this.targeters.toArray(t);
        return t;
    }

    public String toString(boolean verbose) {
        return Utility.format(this.i_position, 4, false, ' ') + ": " + this.instruction.toString(verbose);
    }

    public String toString() {
        return this.toString(true);
    }

    public void addAttribute(Object key, Object attr) {
        if (this.attributes == null) {
            this.attributes = new HashMap<Object, Object>(3);
        }
        this.attributes.put(key, attr);
    }

    public void removeAttribute(Object key) {
        if (this.attributes != null) {
            this.attributes.remove(key);
        }
    }

    public Object getAttribute(Object key) {
        if (this.attributes != null) {
            return this.attributes.get(key);
        }
        return null;
    }

    public Collection<Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<Object, Object>(3);
        }
        return this.attributes.values();
    }

    public void accept(Visitor v) {
        this.instruction.accept(v);
    }
}

