/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.bcel.classfile.AccessFlags;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Annotations;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Signature;

public abstract class FieldOrMethod
extends AccessFlags
implements Cloneable,
Node {
    private static final long serialVersionUID = -1833306330869469714L;
    protected int name_index;
    protected int signature_index;
    protected int attributes_count;
    protected Attribute[] attributes;
    protected AnnotationEntry[] annotationEntries;
    protected ConstantPool constant_pool;
    private String signatureAttributeString = null;
    private boolean searchedForSignatureAttribute = false;
    private boolean annotationsOutOfDate = true;

    FieldOrMethod() {
    }

    protected FieldOrMethod(FieldOrMethod c) {
        this(c.getAccessFlags(), c.getNameIndex(), c.getSignatureIndex(), c.getAttributes(), c.getConstantPool());
    }

    protected FieldOrMethod(DataInputStream file, ConstantPool constant_pool) throws IOException, ClassFormatException {
        this(file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort(), null, constant_pool);
        this.attributes_count = file.readUnsignedShort();
        this.attributes = new Attribute[this.attributes_count];
        for (int i = 0; i < this.attributes_count; ++i) {
            this.attributes[i] = Attribute.readAttribute(file, constant_pool);
        }
    }

    protected FieldOrMethod(int access_flags, int name_index, int signature_index, Attribute[] attributes, ConstantPool constant_pool) {
        this.access_flags = access_flags;
        this.name_index = name_index;
        this.signature_index = signature_index;
        this.constant_pool = constant_pool;
        this.setAttributes(attributes);
    }

    public final void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.access_flags);
        file.writeShort(this.name_index);
        file.writeShort(this.signature_index);
        file.writeShort(this.attributes_count);
        for (int i = 0; i < this.attributes_count; ++i) {
            this.attributes[i].dump(file);
        }
    }

    public final Attribute[] getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(Attribute[] attributes) {
        this.attributes = attributes;
        this.attributes_count = attributes == null ? 0 : attributes.length;
    }

    public final ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final void setConstantPool(ConstantPool constant_pool) {
        this.constant_pool = constant_pool;
    }

    public final int getNameIndex() {
        return this.name_index;
    }

    public final void setNameIndex(int name_index) {
        this.name_index = name_index;
    }

    public final int getSignatureIndex() {
        return this.signature_index;
    }

    public final void setSignatureIndex(int signature_index) {
        this.signature_index = signature_index;
    }

    public final String getName() {
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.name_index, (byte)1);
        return c.getBytes();
    }

    public final String getSignature() {
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.signature_index, (byte)1);
        return c.getBytes();
    }

    protected FieldOrMethod copy_(ConstantPool _constant_pool) {
        FieldOrMethod c = null;
        try {
            c = (FieldOrMethod)this.clone();
        }
        catch (CloneNotSupportedException e) {
            // empty catch block
        }
        c.constant_pool = this.constant_pool;
        c.attributes = new Attribute[this.attributes_count];
        for (int i = 0; i < this.attributes_count; ++i) {
            c.attributes[i] = this.attributes[i].copy(this.constant_pool);
        }
        return c;
    }

    private void ensureAnnotationsUpToDate() {
        if (this.annotationsOutOfDate) {
            Attribute[] attrs = this.getAttributes();
            ArrayList<AnnotationEntry> accumulatedAnnotations = new ArrayList<AnnotationEntry>();
            for (int i = 0; i < attrs.length; ++i) {
                Attribute attribute = attrs[i];
                if (!(attribute instanceof Annotations)) continue;
                Annotations annotations = (Annotations)attribute;
                for (int j = 0; j < annotations.getAnnotationEntries().length; ++j) {
                    accumulatedAnnotations.add(annotations.getAnnotationEntries()[j]);
                }
            }
            this.annotationEntries = accumulatedAnnotations.toArray(new AnnotationEntry[accumulatedAnnotations.size()]);
            this.annotationsOutOfDate = false;
        }
    }

    public AnnotationEntry[] getAnnotationEntries() {
        this.ensureAnnotationsUpToDate();
        return this.annotationEntries;
    }

    public void addAnnotationEntry(AnnotationEntry a) {
        this.ensureAnnotationsUpToDate();
        int len = this.annotationEntries.length;
        AnnotationEntry[] newAnnotations = new AnnotationEntry[len + 1];
        System.arraycopy(this.annotationEntries, 0, newAnnotations, 0, len);
        newAnnotations[len] = a;
        this.annotationEntries = newAnnotations;
    }

    public final String getGenericSignature() {
        if (!this.searchedForSignatureAttribute) {
            boolean found = false;
            for (int i = 0; !found && i < this.attributes_count; ++i) {
                if (!(this.attributes[i] instanceof Signature)) continue;
                this.signatureAttributeString = ((Signature)this.attributes[i]).getSignature();
                found = true;
            }
            this.searchedForSignatureAttribute = true;
        }
        return this.signatureAttributeString;
    }
}

