/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.DoubleArrayListModel;
import chart.GBC;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.beans.EventHandler;
import java.beans.PropertyEditorSupport;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DoubleArrayEditorPanel
extends JPanel {
    private PropertyEditorSupport editor;
    private double[] array;
    private JFormattedTextField sizeField = new JFormattedTextField(new Integer(0));
    private JFormattedTextField valueField = new JFormattedTextField(new Double(0.0));
    private JButton sizeButton = new JButton("Resize");
    private JButton valueButton = new JButton("Change");
    private JList<String> elementList = new JList();
    private DoubleArrayListModel model = new DoubleArrayListModel();

    public DoubleArrayEditorPanel(PropertyEditorSupport ed) {
        this.editor = ed;
        this.setArray((double[])ed.getValue());
        this.setLayout(new GridBagLayout());
        this.add((Component)this.sizeField, new GBC(0, 0, 1, 1).setWeight(100.0, 0.0).setFill(2));
        this.add((Component)this.valueField, new GBC(0, 1, 1, 1).setWeight(100.0, 0.0).setFill(2));
        this.add((Component)this.sizeButton, new GBC(1, 0, 1, 1).setWeight(100.0, 0.0));
        this.add((Component)this.valueButton, new GBC(1, 1, 1, 1).setWeight(100.0, 0.0));
        this.add((Component)new JScrollPane(this.elementList), new GBC(0, 2, 2, 1).setWeight(100.0, 100.0).setFill(1));
        ActionListener listener = EventHandler.create(ActionListener.class, this, "changeSize");
        this.sizeButton.addActionListener(listener);
        this.sizeField.addActionListener(listener);
        listener = EventHandler.create(ActionListener.class, this, "changeValue");
        this.valueButton.addActionListener(listener);
        this.valueField.addActionListener(listener);
        this.elementList.setSelectionMode(0);
        this.elementList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                int i = DoubleArrayEditorPanel.this.elementList.getSelectedIndex();
                if (i < 0) {
                    return;
                }
                DoubleArrayEditorPanel.this.valueField.setValue(DoubleArrayEditorPanel.this.array[i]);
            }
        });
        this.elementList.setModel(this.model);
        this.elementList.setSelectedIndex(0);
    }

    public void changeSize() {
        int s = (Integer)this.sizeField.getValue();
        if (s < 0 || s == this.array.length) {
            return;
        }
        this.setArray(Arrays.copyOf(this.array, s));
        this.editor.setValue(this.array);
    }

    public void changeValue() {
        double v = (Double)this.valueField.getValue();
        int currentIndex = this.elementList.getSelectedIndex();
        if (currentIndex >= 0 && currentIndex < this.array.length) {
            this.model.setValue(currentIndex, v);
            this.elementList.setSelectedIndex(currentIndex);
        }
        this.editor.firePropertyChange();
    }

    private void setArray(double[] v) {
        this.array = v;
        this.model.setArray(this.array);
        this.sizeField.setValue(this.array.length);
        if (this.array.length > 0) {
            this.valueField.setValue(this.array[0]);
            this.elementList.setSelectedIndex(0);
        } else {
            this.valueField.setValue(0.0);
        }
    }
}

