/*
 * Decompiled with CFR 0.152.
 */
package chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;

public class ChartBean
extends JComponent {
    private static final int XPREFSIZE = 300;
    private static final int YPREFSIZE = 300;
    private static final int INSETS = 10;
    private double[] values = new double[]{1.0, 2.0, 3.0};
    private String title = "Title";
    private Position titlePosition = Position.CENTER;
    private boolean inverse;
    private Color color = Color.red;

    public ChartBean() {
        this.setPreferredSize(new Dimension(300, 300));
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.values == null || this.values.length == 0) {
            return;
        }
        double minValue = 0.0;
        double maxValue = 0.0;
        int i = 0;
        while (i < this.values.length) {
            if (minValue > this.getValues(i)) {
                minValue = this.getValues(i);
            }
            if (maxValue < this.getValues(i)) {
                maxValue = this.getValues(i);
            }
            ++i;
        }
        if (maxValue == minValue) {
            return;
        }
        Rectangle bounds = this.getBounds();
        double clientWidth = ((RectangularShape)bounds).getWidth();
        double clientHeight = ((RectangularShape)bounds).getHeight();
        double barWidth = (clientWidth - 20.0) / (double)this.values.length;
        g2.setPaint(this.inverse ? this.color : Color.white);
        g2.fill(new Rectangle2D.Double(0.0, 0.0, clientWidth, clientHeight));
        g2.setPaint(Color.black);
        Font titleFont = new Font("SansSerif", 1, 20);
        FontRenderContext context = g2.getFontRenderContext();
        Rectangle2D titleBounds = titleFont.getStringBounds(this.title, context);
        double titleWidth = titleBounds.getWidth();
        double y = -titleBounds.getY();
        double x = 0.0;
        if (this.titlePosition == Position.CENTER) {
            x += (clientWidth - titleWidth) / 2.0;
        } else if (this.titlePosition == Position.RIGHT) {
            x += clientWidth - titleWidth;
        }
        g2.setFont(titleFont);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.drawString(this.title, (float)x, (float)y);
        double top = titleBounds.getHeight();
        double scale = (clientHeight - top - 20.0) / (maxValue - minValue);
        y = clientHeight;
        int i2 = 0;
        while (i2 < this.values.length) {
            double x1 = 10.0 + (double)i2 * barWidth + 1.0;
            double y1 = 10.0 + top;
            double value = this.getValues(i2);
            double height = value * scale;
            if (value >= 0.0) {
                y1 += (maxValue - value) * scale;
            } else {
                y1 += (double)((int)(maxValue * scale));
                height = -height;
            }
            g2.setPaint(this.inverse ? Color.white : this.color);
            Rectangle2D.Double bar = new Rectangle2D.Double(x1, y1, barWidth - 2.0, height);
            g2.fill(bar);
            g2.setPaint(Color.black);
            g2.draw(bar);
            ++i2;
        }
    }

    public void setTitle(String t) {
        this.title = t;
    }

    public String getTitle() {
        return this.title;
    }

    public void setValues(double[] newValue) {
        double[] oldValue = this.values;
        this.firePropertyChange("values", oldValue, newValue);
        this.values = newValue;
    }

    public double[] getValues() {
        return this.values;
    }

    public void setValues(int i, double value) {
        if (i >= 0 && i < this.values.length) {
            double oldValue = this.values[i];
            this.values[i] = value;
            PropertyChangeListener[] propertyChangeListenerArray = this.getPropertyChangeListeners();
            int n = propertyChangeListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyChangeListener listener = propertyChangeListenerArray[n2];
                listener.propertyChange(new IndexedPropertyChangeEvent(this, "values", oldValue, value, i));
                ++n2;
            }
        }
    }

    public double getValues(int i) {
        if (i >= 0 && i < this.values.length) {
            return this.values[i];
        }
        return 0.0;
    }

    public void setInverse(boolean b) {
        this.inverse = b;
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public void setTitlePosition(Position p) {
        this.titlePosition = p;
    }

    public Position getTitlePosition() {
        return this.titlePosition;
    }

    public void setGraphColor(Color c) {
        this.color = c;
    }

    public Color getGraphColor() {
        return this.color;
    }

    public static enum Position {
        LEFT,
        CENTER,
        RIGHT;

    }
}

