/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Visitor;

public abstract class Annotations
extends Attribute {
    private int annotation_table_length;
    private AnnotationEntry[] annotation_table;
    private boolean isRuntimeVisible;

    public Annotations(byte annotation_type, int name_index, int length, DataInputStream file, ConstantPool constant_pool, boolean isRuntimeVisible) throws IOException {
        this(annotation_type, name_index, length, (AnnotationEntry[])null, constant_pool, isRuntimeVisible);
        this.annotation_table_length = file.readUnsignedShort();
        this.annotation_table = new AnnotationEntry[this.annotation_table_length];
        for (int i = 0; i < this.annotation_table_length; ++i) {
            this.annotation_table[i] = AnnotationEntry.read(file, constant_pool, isRuntimeVisible);
        }
    }

    public Annotations(byte annotation_type, int name_index, int length, AnnotationEntry[] annotation_table, ConstantPool constant_pool, boolean isRuntimeVisible) {
        super(annotation_type, name_index, length, constant_pool);
        this.setAnnotationTable(annotation_table);
        this.isRuntimeVisible = isRuntimeVisible;
    }

    public void accept(Visitor v) {
        v.visitAnnotation(this);
    }

    public final void setAnnotationTable(AnnotationEntry[] annotation_table) {
        this.annotation_table = annotation_table;
        this.annotation_table_length = annotation_table == null ? 0 : annotation_table.length;
    }

    public AnnotationEntry[] getAnnotationEntries() {
        return this.annotation_table;
    }

    public final int getNumAnnotations() {
        return this.annotation_table_length;
    }

    public boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    protected void writeAnnotations(DataOutputStream dos) throws IOException {
        dos.writeShort(this.annotation_table_length);
        for (int i = 0; i < this.annotation_table_length; ++i) {
            this.annotation_table[i].dump(dos);
        }
    }
}

