package com.brackeen.javagamebook.graphics;

import java.awt.Image;
import java.util.ArrayList;

/**
    Klasa Animation zarzdza seri rysunkw (ramek)oraz
    czasem wywietlania kadej z ramek.
*/
public class Animation {

    private ArrayList frames;
    private int currFrameIndex;
    private long animTime;
    private long totalDuration;


    /**
        Tworzy nowy pusty obiekt Animation.
    */
    public Animation() {
        this(new ArrayList(), 0);
    }


    private Animation(ArrayList frames, long totalDuration) {
        this.frames = frames;
        this.totalDuration = totalDuration;
        start();
    }


    /**
        Tworzy kopi tej animacji. Lista ramek jest wspdzielona
        midzy dwoma obiektami Animation, ale kada z nich moe by
        animowana niezalenie.
    */
    public Object clone() {
        return new Animation(frames, totalDuration);
    }


    /**
        Dodaje do animacji rysunek o okrelonym czasie wywietlania.
    */
    public synchronized void addFrame(Image image,
        long duration)
    {
        totalDuration += duration;
        frames.add(new AnimFrame(image, totalDuration));
    }


    /**
        Uruchamia animacj od pocztku.
    */
    public synchronized void start() {
        animTime = 0;
        currFrameIndex = 0;
    }


    /**
        W razie potrzeby modyfikuje biec ramk (rysunek) animacji.
    */
    public synchronized void update(long elapsedTime) {
        if (frames.size() > 1) {
            animTime += elapsedTime;

            if (animTime >= totalDuration) {
                animTime = animTime % totalDuration;
                currFrameIndex = 0;
            }

            while (animTime > getFrame(currFrameIndex).endTime) {
                currFrameIndex++;
            }
        }
    }


    /**
        Pobiera biecy rysunek z animacji. Zwraca null
        jeeli animacja nie zawiera rysunkw.
    */
    public synchronized Image getImage() {
        if (frames.size() == 0) {
            return null;
        }
        else {
            return getFrame(currFrameIndex).image;
        }
    }


    private AnimFrame getFrame(int i) {
        return (AnimFrame)frames.get(i);
    }


    private class AnimFrame {

        Image image;
        long endTime;

        public AnimFrame(Image image, long endTime) {
            this.image = image;
            this.endTime = endTime;
        }
    }
}
