package com.brackeen.javagamebook.graphics;

import javax.swing.RepaintManager;
import javax.swing.JComponent;

/**
    Klasa NullRepaintManager dziedziczy po RepaintManager i nic nie robi
    Przydatna w przypadku aplikacji samodzielnie obsugujcych
    rendering.
*/
public class NullRepaintManager extends RepaintManager {

    /**
        Instaluje NullRepaintManager.
    */
    public static void install() {
        RepaintManager repaintManager = new NullRepaintManager();
        repaintManager.setDoubleBufferingEnabled(false);
        RepaintManager.setCurrentManager(repaintManager);
    }

    public void addInvalidComponent(JComponent c) {
        // nic nie rb
    }

    public void addDirtyRegion(JComponent c, int x, int y,
        int w, int h)
    {
        // nic nie rb
    }

    public void markCompletelyDirty(JComponent c) {
        // nic nie rb
    }

    public void paintDirtyRegions() {
        // nic nie rb
    }
}
