package com.brackeen.javagamebook.math3D;


/**
    Klasa PolygonGroupBounds reprezentuje walec otaczajcy
    obiekt PolygonGroup, ktry mona wykorzysta do wykrywania
    kolizji.
*/
public class PolygonGroupBounds {

    private float topHeight;
    private float bottomHeight;
    private float radius;


    /**
        Tworzy nowy obiekt PolygonGroupBounds bez bryy otaczajcej.
    */
    public PolygonGroupBounds() {

    }


    /**
        Tworzy nowy obiekt PolygonGroupBounds z otaczajcym obiektem
        PolygonGroup.
    */
    public PolygonGroupBounds(PolygonGroup group) {
        setToBounds(group);
    }


    /**
        Ustawia ograniczenia dla wskazanego obiektu PolygonGroup.
    */
    public void setToBounds(PolygonGroup group) {
        topHeight = Float.MIN_VALUE;
        bottomHeight = Float.MAX_VALUE;
        radius = 0;

        group.resetIterator();
        while (group.hasNext()) {
            Polygon3D poly = group.nextPolygon();
            for (int i=0; i<poly.getNumVertices(); i++) {
                Vector3D v = poly.getVertex(i);
                topHeight = Math.max(topHeight, v.y);
                bottomHeight = Math.min(bottomHeight, v.y);
                // oblicza promie podniesiony do kwadratu
                radius = Math.max(radius, v.x*v.x + v.z*v.z);
            }
        }

        if (radius == 0) {
            // pusta grupa wieloktw!
            topHeight = 0;
            bottomHeight = 0;
        }
        else {
            radius = (float)Math.sqrt(radius);
        }
    }

    public float getTopHeight() {
        return topHeight;
    }

    public void setTopHeight(float topHeight) {
        this.topHeight = topHeight;
    }

    public float getBottomHeight() {
        return bottomHeight;
    }

    public void setBottomHeight(float bottomHeight) {
        this.bottomHeight = bottomHeight;
    }

    public float getRadius() {
        return radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }


}
