package com.brackeen.javagamebook.scripting;

import java.util.*;
import com.brackeen.javagamebook.game.GameObject;

/**
    Adapter do rozsyania powiadomie GameObject do wielu obiektw nasuchu.
*/
public class GameObjectEventMulticaster
    implements GameObjectEventListener
{

    private List listeners;

    public GameObjectEventMulticaster(GameObjectEventListener l1,
        GameObjectEventListener l2)
    {
        listeners = new LinkedList();
        addListener(l1);
        addListener(l2);
    }

    public void addListener(GameObjectEventListener l) {
        if (l != null) {
            listeners.add(l);
        }
    }


    public void removeListener(GameObjectEventListener l) {
        if (l != null) {
            listeners.remove(l);
        }
    }

    /**
        Powiadamia GameObject czy by widoczny podczas ostatniej aktualizacji.
    */
    public void notifyVisible(GameObject object, boolean visible) {
        Iterator i = listeners.iterator();
        while (i.hasNext()) {
            GameObjectEventListener l =
                (GameObjectEventListener)i.next();
            l.notifyVisible(object, visible);
        }
    }


    /**
        Powiadamia GameObject gdy jest przesunity, lub koliduje
        z innym obiektem.
    */
    public void notifyObjectCollision(GameObject object,
        GameObject otherObject)
    {
        Iterator i = listeners.iterator();
        while (i.hasNext()) {
            GameObjectEventListener l =
                (GameObjectEventListener)i.next();
            l.notifyObjectCollision(object, otherObject);
        }
    }


    public void notifyObjectTouch(GameObject object,
        GameObject otherObject)
    {
        Iterator i = listeners.iterator();
        while (i.hasNext()) {
            GameObjectEventListener l =
                (GameObjectEventListener)i.next();
            l.notifyObjectTouch(object, otherObject);
        }
    }


    public void notifyObjectRelease(GameObject object,
        GameObject otherObject)
    {
        Iterator i = listeners.iterator();
        while (i.hasNext()) {
            GameObjectEventListener l =
                (GameObjectEventListener)i.next();
            l.notifyObjectRelease(object, otherObject);
        }
    }


    /**
        Powiadamia GameObject e w czasie ruchu koliduje z podog.
    */
    public void notifyFloorCollision(GameObject object) {
        Iterator i = listeners.iterator();
        while (i.hasNext()) {
            GameObjectEventListener l =
                (GameObjectEventListener)i.next();
            l.notifyFloorCollision(object);
        }
    }


    /**
        Powiadamia GameObject e w czasie ruchu koliduje z sufitem.
    */
    public void notifyCeilingCollision(GameObject object) {
        Iterator i = listeners.iterator();
        while (i.hasNext()) {
            GameObjectEventListener l =
                (GameObjectEventListener)i.next();
            l.notifyCeilingCollision(object);
        }
    }


    /**
        Powiadamia GameObject e w czasie ruchu koliduje ze cian.
    */
    public void notifyWallCollision(GameObject object) {
        Iterator i = listeners.iterator();
        while (i.hasNext()) {
            GameObjectEventListener l =
                (GameObjectEventListener)i.next();
            l.notifyWallCollision(object);
        }
    }
}

