package com.brackeen.javagamebook.path;

import java.util.List;
import com.brackeen.javagamebook.util.MoreMath;

/**
    Klasa AStarNode wraz z klas AStarSearch implementuj oglny
    algorytm przeszukiwania A*. Aby umoliwi wykonanie konkretnego
    przeszukiwania, klasa AStarNode powinna zosta podklasowana. 
*/
public abstract class AStarNode implements Comparable {

    AStarNode pathParent;
    float costFromStart;
    float estimatedCostToGoal;


    public float getCost() {
        return costFromStart + estimatedCostToGoal;
    }


    public int compareTo(Object other) {
        float otherValue = ((AStarNode)other).getCost();
        float thisValue = this.getCost();

        return MoreMath.sign(thisValue - otherValue);
    }


    /**
        Pobiera koszt podry midzy tym wzem a podanym 
        wzem ssiadujcym (tj. "ssiadem" lub "potomkiem").
    */
    public abstract float getCost(AStarNode node);


    /**
        Pobiera szacunkowy koszt podry midzy tym wzem, 
        a podanym wzem. Szacunkowy koszt nie powinien przekracza 
        rzeczywistego kosztu. Im lepsza bdzie nasza estymacja, 
        tym efektywniejsze bdzie przeszukiwanie.
    */
    public abstract float getEstimatedCost(AStarNode node);


    /**
        Pobiera potomkw (tj. "ssiadw" lub "wzy ssiadujce")
        tego wza.
    */
    public abstract List getNeighbors();
}