package com.brackeen.javagamebook.path;

import java.util.Iterator;
import com.brackeen.javagamebook.game.GameObject;
import com.brackeen.javagamebook.math3D.Vector3D;

/**
    Interfejs PathFinder jest funkcj, ktra odnajduje ciek
    (list List wektorw Vector3Ds) z jednej lokacji do drugiej
    lub od jednego obiektu gry GameObject do drugiego. Zauwamy,
    e metoda find() moe zignorowa zadany jej cel i zamiast tego
    zwrci arbitraln ciek, by np. patrolowa okrelon tras
    lub ucieka od celu.
*/
public interface PathFinder {

    /**
        Odnajduje ciek od obiektu GameObject A do obiektu GameObject B. 
        cieka ta to Iterator wektorw Vector3Ds i nie zawiera startowej
        lokacji (GameObject A), zawiera natomiast lokacj docelow
        (GameObject B). Obiekty wektorw Vector3D mog by wykorzystywane
        przez inne obiekty, wic nie powinny by modyfikowane.
        Zwraca null, jeli nie mona znale cieki.
    */
    public Iterator find(GameObject a, GameObject b);


    /**
        Odnajduje ciek od lokacji startowej do celu. 
        cieka to Iterator wektorw Vector3Ds i nie zawiera
        startowej lokacji, ale zawiera lokacj celu.
        Obiekty wektorw Vector3D mog by wykorzystywane
        przez inne obiekty, wic nie powinny by modyfikowane.
        Zwraca null, jeli nie mona znale cieki.
    */
    public Iterator find(Vector3D start, Vector3D goal);
}
