public class BinaryTreeTest {

    public static void main(String[] args) {
        new BinaryTreeTest().run();
    }

    static class Node {
        Node left;
        Node right;
        int value;

        public Node(int value) {
            this.value = value;
        }
    }

    public void run() {
        // zbuduj proste drzewo z rozdziau 11.
        Node root = new Node(5);
        System.out.println("Przykad drzewa binarnego");
        System.out.println("Budowa drzewa z wartoci w korzeniu: " +
            root.value);
        insert(root, 1);
        insert(root, 8);
        insert(root, 6);
        insert(root, 3);
        insert(root, 9);
        System.out.println("Poprzeczne przeszukiwanie drzewa");
        printInOrder(root);
        System.out.println("Przeszukiwanie drzewa od przodu do tyu od pooenia 7");
        printFrontToBack(root, 7);
    }


    public void insert(Node node, int value) {
        if (value < node.value) {
            if (node.left != null) {
                insert(node.left, value);
            }
            else {
                System.out.println("  Inserted " + value +
                    " to left of " + node.value);
                node.left = new Node(value);
            }
        }
        else if (value > node.value) {
            if (node.right != null) {
                insert(node.right, value);
            }
            else {
                System.out.println("  Inserted " + value +
                    " to right of " + node.value);
                node.right = new Node(value);
            }
        }
    }


    public void printInOrder(Node node) {
        if (node != null) {
            printInOrder(node.left);
            System.out.println("  Odwiedzony wze: " + node.value);
            printInOrder(node.right);
        }
    }

    /**
        Uywa metody przegldania poprzecznego, jeli przodek jest mniejszy od
        wartoci potomka.

        Uywa metody przegldania wstecznego, jeli przodek jest wikszy od
        wartoci potomka.
    */
    public void printFrontToBack(Node node, int camera) {
        if (node == null) return;
        if (node.value > camera) {
            // wywietla w kolejnoci poprzecznej
            printFrontToBack(node.left, camera);
            System.out.println("  Odwiedzony wze: " + node.value);
            printFrontToBack(node.right, camera);
        }
        else if (node.value < camera) {
            // wywietla w kolejnoci wstecznej
            printFrontToBack(node.right, camera);
            System.out.println("  Odwiedzony wze: " + node.value);
            printFrontToBack(node.left, camera);
        }
        else {
            // kolejno nie ma znaczenia
            printFrontToBack(node.left, camera);
            printFrontToBack(node.right, camera);
        }
    }


}
