package com.brackeen.javagamebook.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;

/**
    Klasa LoopingByteInputStream dziedziczy po ByteArrayInputStream
    z dodanym zaptleniem. Ptla zostaje przerwana po wywoaniu
    metody close().
    <p>Moliwe rozszerzenia tej klasy:<ul>
    <li>Dodanie opcji wykonywania okrelonej iloci przebiegw.
    </ul>
*/
public class LoopingByteInputStream extends ByteArrayInputStream {

    private boolean closed;

    /**
        Tworzenie nowego obiektu LoopingByteInputStream z podan
        tablica bajtw. Tablica nie jest kopiowana.
    */
    public LoopingByteInputStream(byte[] buffer) {
        super(buffer);
        closed = false;
    }

    /**
        Odczytuje <code>length</code> bajtw z tablicy. Jeeli
        zostanie osignity koniec tablicy, odczyt zaczyna si ponownie
        od jej pocztku. Po zamkniciu tablicy zwraca -1.
    */
    public int read(byte[] buffer, int offset, int length) {
        if (closed) {
            return -1;
        }
        int totalBytesRead = 0;

        while (totalBytesRead < length) {
            int numBytesRead = super.read(buffer,
                offset + totalBytesRead,
                length - totalBytesRead);

            if (numBytesRead > 0) {
                totalBytesRead += numBytesRead;
            }
            else {
                reset();
            }
        }
        return totalBytesRead;
    }

    /**
        Zamyka strumie. Kolejne wywoania metody read() zwracaj
        zwrc -1.
    */
    public void close() throws IOException {
        super.close();
        closed = true;
    }
}
