package com.brackeen.javagamebook.graphics;
import java.awt.Image;

public class Sprite {

    private Animation anim;
    // Pozycja (piksele):
    private float x;
    private float y;
    // Prdko (piksele na milisekund):
    private float dx;
    private float dy;

    /**
        Tworzy nowy obiekt Sprite z waciwym obiektem Animation.
    */
    public Sprite(Animation anim) {
        this.anim = anim;
    }

    /**
        Aktualizuje obiekt Animation dla biecego Sprite 
        oraz swoj pozycj na podstawie prdkoci.
    */
    public void update(long elapsedTime) {
        x += dx * elapsedTime;
        y += dy * elapsedTime;
        anim.update(elapsedTime);
    }

    /**
        Zwraca wsprzdn x biecego obiektu Sprite.
    */
    public float getX() {
        return x;
    }

    /**
        Zwraca wsprzdn x biecego obiektu Sprite.
    */
    public float getY() {
        return y;
    }

    /**
        Ustawia wsprzdn x biecego obiektu Sprite.
    */
    public void setX(float x) {
        this.x = x;
    }

    /**
        Ustawia wsprzdn y biecego obiektu Sprite.
    */
    public void setY(float y) {
        this.y = y;
    }

    /**
        Zwraca szeroko biecego obiektu Sprite, 
        korzystajc z rozmiaru biecego rysunku.
    */
    public int getWidth() {
        return anim.getImage().getWidth(null);
    }

    /**
        Zwraca wysoko biecego obiektu Sprite, 
        korzystajc z rozmiaru biecego rysunku.
    */
    public int getHeight() {
        return anim.getImage().getHeight(null);
    }

    /**
        Zwraca prdko w poziomie biecego obiektu Sprite 
        w pikselach na milisekund.
    */
    public float getVelocityX() {
        return dx;
    }

    /**
        Zwraca prdko w pionie biecego obiektu Sprite 
        w pikselach na milisekund.
    */
    public float getVelocityY() {
        return dy;
    }

    /**
        Ustawia prdko w poziomie biecego obiektu Sprite 
        w pikselach na milisekund.
    */
    public void setVelocityX(float dx) {
        this.dx = dx;
    }

    /**
        Ustawia prdko w pionie biecego obiektu Sprite 
        w pikselach na milisekund.
    */
    public void setVelocityY(float dy) {
        this.dy = dy;
    }

    /**
        Zwraca biecy rysunek dla tego obiektu Sprite.
    */
    public Image getImage() {
        return anim.getImage();
    }
}
