import java.io.File;
import javax.sound.sampled.*;

/**
    Przykad adowania i odtwarzania dwiku z wykorzystaniem obiektu Clip.
    Klasa ta nie jest zamnieszczona w ksice.
*/
public class ClipTest {

    public static void main(String[] args) throws Exception {

        // okrelenie dwiku do odtworzenia
        // (zakadamy, e system dwiekowy moe go odtworzy)
        File soundFile = new File("../sounds/voice.wav");
        AudioInputStream sound =
            AudioSystem.getAudioInputStream(soundFile);

        // adowanie dwiku do pamici (Clip)
        DataLine.Info info = new DataLine.Info(Clip.class,
            sound.getFormat());
        Clip clip = (Clip)AudioSystem.getLine(info);
        clip.open(sound);

        // z powodu bdu w Java Sound, jawnie zakocz prac VM
        // po zakoczeniu dwiku.
        clip.addLineListener(new LineListener() {
            public void update(LineEvent event) {
                if (event.getType() == LineEvent.Type.STOP) {
                    event.getLine().close();
                    System.exit(0);
                }
            }
        });

        // odtworzenie dwiku
        clip.start();
    }
}
