package com.brackeen.javagamebook.util;

/**
    Wygadza skoki w odczycie czasu z sabego zegara.
    Jest to prosty algorytm, ktry jest nieco niedokadny 
    (czas wygadzony nieco pieszy si w stosunku do biecego), ale
    daje lepiej wygldajce wyniki.
*/
public class TimeSmoothie {

    /**
        Jak czsto przelicza ilo ramek na sekund.
    */
    protected static final long FRAME_RATE_RECALC_PERIOD = 500;

    /**
        Nie pozwalamy na czas midzy ramkami duszy ni 100 ms.
    */
    protected static final long MAX_ELAPSED_TIME = 100;

    /**
        rednia z kilku ostatnich prbek zebranych w czasie ostatnich 100 ms.
    */
    protected static final long AVERAGE_PERIOD = 100;

    protected static final int NUM_SAMPLES_BITS = 6; // 64 prbki
    protected static final int NUM_SAMPLES = 1 << NUM_SAMPLES_BITS;
    protected static final int NUM_SAMPLES_MASK = NUM_SAMPLES - 1;

    protected long[] samples;
    protected int numSamples = 0;
    protected int firstIndex = 0;

    // do obliczania iloci ramek na sekund
    protected int numFrames = 0;
    protected long startTime;
    protected float frameRate;

    public TimeSmoothie() {
        samples = new long[NUM_SAMPLES];
    }

    /**
        Dodaje okrelon prbk czasu i zwraca redni 
        z wszystkich zapisanych prbek.
    */
    public long getTime(long elapsedTime) {
        addSample(elapsedTime);
        return getAverage();
    }

    /**
        Dodaje prbk czasu.
    */
    public void addSample(long elapsedTime) {
        numFrames++;

        // odczytanie czasu
        elapsedTime = Math.min(elapsedTime, MAX_ELAPSED_TIME);

        // dodanie prbki do listy
        samples[(firstIndex + numSamples) & NUM_SAMPLES_MASK] =
            elapsedTime;
        if (numSamples == samples.length) {
            firstIndex = (firstIndex + 1) & NUM_SAMPLES_MASK;
        }
        else {
            numSamples++;
        }
    }

    /**
        Pobieranie redniej z zapisanych prbek dwiku.
    */
    public long getAverage() {
        long sum = 0;
        for (int i=numSamples-1; i>=0; i--) {
            sum+=samples[(firstIndex + i) & NUM_SAMPLES_MASK];

            // jeeli osignity zosta okres uredniania, obliczamy 
            // i zwracamy redni.
            if (sum >= AVERAGE_PERIOD) {
                Math.round((double)sum / (numSamples-i));
            }
        }
        return Math.round((double)sum / numSamples);
    }


    /**
        Zwraca ilo ramek na sekund (ilo wywoa getTime() lub
        addSample() w czasie rzeczywistym). Ilo ramek na sekund 
        jest przeliczana co 500ms.
    */
    public float getFrameRate() {
        long currTime = System.currentTimeMillis();

        // obliczenie iloci ramek na sekund co 500 milisekund
        if (currTime > startTime + FRAME_RATE_RECALC_PERIOD) {
            frameRate = (float)numFrames * 1000 /
                (currTime - startTime);
            startTime = currTime;
            numFrames = 0;
        }

        return frameRate;
    }
}
