package com.brackeen.javagamebook.shooter3D;

import com.brackeen.javagamebook.math3D.*;
import com.brackeen.javagamebook.game.*;

/**
    Obiekt klasy GameObject, ktry moe skaka.
*/
public class JumpingGameObject extends GameObject {

    public static final float DEFAULT_JUMP_HEIGHT = 64;

    protected float jumpVelocity;

    public JumpingGameObject(PolygonGroup group) {
        super(group);
        setJumpHeight(DEFAULT_JUMP_HEIGHT);
    }

    /**
        Ustawia wysoko, na jak ten obiekt GameObject moe podskoczy.
    */
    public void setJumpHeight(float jumpHeight) {
        jumpVelocity =
            Physics.getInstance().getJumpVelocity(jumpHeight);
    }


    /**
        Powoduje skok tego obiektu GameObject, jeli ustawiona jest jego
        flaga skakania i obiekt aktualnie nie skacze.
    */
    public void setJumping(boolean isJumping) {
        if (isJumping() != isJumping) {
            super.setJumping(isJumping);
            if (isJumping) {
                Physics.getInstance().jump(this, jumpVelocity);
            }
        }
    }


    public void notifyFloorCollision() {
        // obiekt wyldowa
        setJumping(false);
    }

}
