package com.brackeen.javagamebook.ai.pattern;

import java.util.Iterator;
import java.util.Collections;
import com.brackeen.javagamebook.game.GameObject;
import com.brackeen.javagamebook.math3D.Vector3D;
import com.brackeen.javagamebook.bsp2D.BSPTree;
import com.brackeen.javagamebook.util.MoreMath;

/**
    Bezporednie celowanie w gracza, z losowym odchyleniem. Wzorce celowania
    zwracaj kierunek strzeu, nie punkt, w ktry bot celuje.
*/
public class AimPattern extends AIPattern {

    protected float accuracy;

    public AimPattern(BSPTree tree) {
        super(tree);
    }

    /**
        Ustawia celno od 0 (najgorsza) do 1 (najlepsza).
    */
    public void setAccuracy(float p) {
        this.accuracy = p;
    }


    public Iterator find(GameObject bot, GameObject player) {
        Vector3D goal = new Vector3D(player.getLocation());
        goal.y += player.getBounds().getTopHeight() / 2;
        goal.subtract(bot.getLocation());

        // Obrt maksymalnie o 10 stopni wok osi y
        // (w tym miejscu mona rwnie dobrze wprowadzi
        // odchylenia w gr lub w d).
        if (accuracy < 1) {
            float maxAngle = 10 * (1-accuracy);
            float angle = MoreMath.random(-maxAngle, maxAngle);
            goal.rotateY((float)Math.toRadians(angle));
        }

        goal.normalize();

        // zwraca iterator
        return Collections.singleton(goal).iterator();
    }
}
