import java.awt.*;
import java.awt.event.*;
import java.util.LinkedList;

import com.brackeen.javagamebook.graphics.*;
import com.brackeen.javagamebook.test.GameCore;

/**
    Prosty test obsugi myszy. Rysuje tekst "Witaj wiecie!" 
    w miejscu pooenia kursora. Kliknicie przecza 
    w tryb "ladu", pozwalajcy na narysowanie kilku komunikatw. 
    Do zmiany kolorw mona uy kka myszy (o ile jest dostpne).
*/
public class MouseTest extends GameCore implements KeyListener,
    MouseMotionListener, MouseListener, MouseWheelListener

{

    public static void main(String[] args) {
        new MouseTest().run();
    }

    private static final int TRAIL_SIZE = 10;
    private static final Color[] COLORS = {
        Color.white, Color.black, Color.yellow, Color.magenta
    };

    private LinkedList trailList;
    private boolean trailMode;
    private int colorIndex;

    public void init() {
        super.init();
        trailList = new LinkedList();

        Window window = screen.getFullScreenWindow();
        window.addMouseListener(this);
        window.addMouseMotionListener(this);
        window.addMouseWheelListener(this);
        window.addKeyListener(this);
    }

    public synchronized void draw(Graphics2D g) {
        int count = trailList.size();

        if (count > 1 && !trailMode) {
            count = 1;
        }

        Window window = screen.getFullScreenWindow();

        // Rysowanie ta:
        g.setColor(window.getBackground());
        g.fillRect(0, 0, screen.getWidth(), screen.getHeight());

        // Instrukcje dotyczce rysowania:
        g.setRenderingHint(
                RenderingHints.KEY_TEXT_ANTIALIASING,
                RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setColor(window.getForeground());
        g.drawString("MouseTest. Nacinij Esc, aby zakoczy.", 5,
            FONT_SIZE);

        // Rysowanie ladu myszy:
        for (int i=0; i<count; i++) {
            Point p = (Point)trailList.get(i);
            g.drawString("Witaj wiecie!", p.x, p.y);
        }
    }

    // Z interfejsu MouseListener:
    public void mousePressed(MouseEvent e) {
        trailMode = !trailMode;
    }

    // Z interfejsu MouseListener:
    public void mouseReleased(MouseEvent e) {
        // nic nie rb
    }

    // Z interfejsu MouseListener:
    public void mouseClicked(MouseEvent e) {
        // metoda wywoywana po zwolnieniu klawisza myszy - ignorowana
    }

    // Z interfejsu MouseListener:
    public void mouseEntered(MouseEvent e) {
        mouseMoved(e);
    }

    // Z interfejsu MouseListener:
    public void mouseExited(MouseEvent e) {
        mouseMoved(e);
    }

    // Z interfejsu MouseMotionListener:
    public void mouseDragged(MouseEvent e) {
        mouseMoved(e);
    }

    // Z interfejsu MouseMotionListener:
    public synchronized void mouseMoved(MouseEvent e) {
        Point p = new Point(e.getX(), e.getY());
        trailList.addFirst(p);
        while (trailList.size() > TRAIL_SIZE) {
            trailList.removeLast();
        }
    }

    // Z interfejsu MouseWheelListener:
    public void mouseWheelMoved(MouseWheelEvent e) {
        colorIndex = (colorIndex + e.getWheelRotation()) %
            COLORS.length;

        if (colorIndex < 0) {
            colorIndex+=COLORS.length;
        }
        Window window = screen.getFullScreenWindow();
        window.setForeground(COLORS[colorIndex]);
    }

    // Z interfejsu KeyListener:
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
            // Zakoczenie pracy programu:
            stop();
        }
    }

    // Z interfejsu KeyListener:
    public void keyReleased(KeyEvent e) {
        // Nic nie wykonuj.
    }

    // Z interfejsu KeyListener:
    public void keyTyped(KeyEvent e) {
        // Nic nie wykonuj.
    }
}
