package com.brackeen.javagamebook.scripting;

import java.util.*;

/**
    Zarzdza kolejka obiektw GameTask.
*/
public class GameTaskManager {

    private List tasks;


    /**
        Tworzy nowy obiekt GameTaskManager z pust kolejk zada.
    */
    public GameTaskManager() {
        tasks = new ArrayList();
    }


    /**
        Dodaje zadanie do kolejki, ktre wykonuje okrelony obiekt
        runnable po zadanym czasie opnienia.
    */
    public void addTask(long delay, Runnable runnable) {
        addTask(new GameTask(delay, runnable));
    }

    /**
        Dodaje zadanie do kolejki.
    */
    public void addTask(GameTask task) {
        tasks.add(task);
    }

    /**
        Czyci kolejk zada.
    */
    public void clear() {
        tasks.clear();
    }

    /**
        Aktualizuje tego zarzdce, uruchamiajc wszystkie gotowe zadania.
    */
    public void update(long elapsedTime) {

        List removeList = null;
        int size = tasks.size();

        // pamitaj, e wykonanie zadania moe potencjalnie spowodowa dodanie
        // nowych zada do kolejki.
        for (int i=0; i<size; i++) {
            GameTask task = (GameTask)tasks.get(i);
            if (task.check(elapsedTime)) {
                // dodanie obiektu do listy obiektw do pniejszego usunicia
                if (removeList == null) {
                    removeList = new ArrayList();
                }
                removeList.add(task);
            }
        }
        // usuwanie wykonanych zada
        if (removeList != null) {
            tasks.removeAll(removeList);
        }
    }
}
