package com.brackeen.javagamebook.graphics3D.texture;

/**
    Klasa PowerOf2Texture jest klas Texture o szerokoci i wysokoci
    rwnych jakiej potdze liczby 2 (32, 128, etc.).
*/
public final class PowerOf2Texture extends Texture {

    private short[] buffer;
    private int widthBits;
    private int widthMask;
    private int heightBits;
    private int heightMask;

    /**
        Tworzy now tekstur PowerOf2Texture o podanym buforze.
        Szeroko mapy bitowej to 2 do potgi widthBits lub inaczej
        (1 << widthBits). Podobnie, wysoko mapy bitowej to 2
        do potgi heightBits lub inaczej (1 << heightBits).
    */
    public PowerOf2Texture(short[] buffer,
        int widthBits, int heightBits)
    {
        super(1 << widthBits, 1 << heightBits);
        this.buffer = buffer;
        this.widthBits = widthBits;
        this.heightBits = heightBits;
        this.widthMask = getWidth() - 1;
        this.heightMask = getHeight() - 1;
    }


    /**
        Pobiera 16-bitowy kolor piksela w punkcie (x,y)
        mapy bitowej.
    */
    public short getColor(int x, int y) {
        return buffer[
            (x & widthMask) +
            ((y & heightMask) << widthBits)];
    }

}
