package com.brackeen.javagamebook.game;

import java.awt.Rectangle;
import java.awt.Graphics2D;
import com.brackeen.javagamebook.game.GameObjectRenderer;

/**
    Interfejs GameObjectManager zawiera metody umoliwiajce
    ledzenie i rysowanie obiektw GameObject.
*/
public interface GameObjectManager {


    /**
        Oznacza wszystkie obiekty znajdujce si w wyznaczonym
        dwuwymiarowym obszarze jako potencjalnie widoczne (czyli
        takie, ktre naley narysowa).
    */
    public void markVisible(Rectangle bounds);


    /**
        Oznacza wszystkie obiekty jako potencjalnie widoczne (czyli
        takie, ktre naley narysowa).
    */
    public void markAllVisible();


    /**
        Dodaje obiekt klasy GameObject do tego menadera.
    */
    public void add(GameObject object);


    /**
        Dodaje obiekt klasy GameObject do tego menadera i okrela
        go jako obiekt gracza. Istniejcy obiekt gracza, jeli istnieje,
        nie jest usuwany.
    */
    public void addPlayer(GameObject player);


    /**
        Zwraca obiekt okrelony jako obiekt gracza lub warto null,
        jeli nie wyznaczono adnego obiektu gracza.
    */
    public GameObject getPlayer();


    /**
        Usuwa obiekt klasy GameObject z tego menadera.
    */
    public void remove(GameObject object);


    /**
        Aktualizuje wszystkie obiekty w oparciu o czas, jaki min
        od ostatniej aktualizacji.
    */
    public void update(long elapsedTime);


    /**
        Rysuje wszystkie widoczne obiekty.
    */
    public void draw(Graphics2D g, GameObjectRenderer r);

}
