package com.brackeen.javagamebook.util;

/**
    Monitoruje rozmiar sterty, rozmiar alokacji, zmiany w alokacji,
    zmiany w rozmiarze sterty i wykrywa zbieranie nieuytkw (gdy
    zmniejsza si wielko alokacji). Wywoaj takeSample() aby odczyta
    "prbk" biecego stanu pamici.
*/
public class MemMonitor {

    /**
        Klasa Data zawiera informacje na temat serii wartoci 
        zmiennoprzecinkowych. Mona pobra minimaln, maksymaln,
        sum i ilo danych.
    */
    public static class Data {

        float lastValue = 0;
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        float sum = 0;
        int count = 0;

        public void addValue(float value) {
            lastValue = value;
            sum+=value;
            count++;
            min = Math.min(min, value);
            max = Math.max(max, value);
        }


        public String toString() {
            return "Min: " + toByteFormat(min) + "  " +
                   "Max: " + toByteFormat(max) + "  " +
                   "re: " + toByteFormat(sum / count);
        }
    }

    private Data heapSize = new Data();
    private Data allocSize = new Data();
    private Data allocIncPerUpdate = new Data();
    private int numHeapIncs = 0;
    private long startTime = System.currentTimeMillis();


    /**
        Odczytuje prbk biecego stanu pamici.
    */
    public void takeSample() {
        Runtime runtime = Runtime.getRuntime();
        long currHeapSize = runtime.totalMemory();
        long currAllocSize = currHeapSize - runtime.freeMemory();

        if (currHeapSize > heapSize.lastValue) {
            numHeapIncs++;
        }
        if (currAllocSize >= allocSize.lastValue) {
            allocIncPerUpdate.addValue(
                (currAllocSize - allocSize.lastValue));
        }

        heapSize.addValue(currHeapSize);
        allocSize.addValue(currAllocSize);
    }


    /**
        Konwertuje liczb bajtw na reprezentacj w postaci cigu 
        reprezentujcego bajty, kilobajty, megabajty ,itd.
    */
    public static String toByteFormat(float numBytes) {
        String[] labels = {" bajtw", " KB", " MB", " GB"};
        int labelIndex = 0;

        // wybr najbardziej odpowiedniej etykiety
        while (labelIndex < labels.length - 1 && numBytes > 1024) {
            numBytes/=1024;
            labelIndex++;
        }
        return (Math.round(numBytes*10)/10f) + labels[labelIndex];
    }


    public String toString() {
        long time = System.currentTimeMillis() - startTime;
        float timeSecs = (float)time / 1000;
        return "Cakowity czas: " + timeSecs + " s\n" +
            "Sterta: " + heapSize + "\n" +
            "Alokacje: " + allocSize + "\n" +
            "Powiksze alokacji: " + allocIncPerUpdate + "\n" +
            "Ilo powiksze sterty: " + numHeapIncs;
    }
}
