/**
    Mierzy rozdzielczo zegara System.currentTimeMillis().
*/
public class GranularityTest {

    public static final int NUM_SAMPLES = 100;

    public static void main(String[] args) {
        long sum = 0;
        int count = 0;

        long lastTime = System.currentTimeMillis();
        while (count < NUM_SAMPLES) {
            long currTime = System.currentTimeMillis();

            // jeeli czas si zmieni, zapisz rnic
            if (currTime > lastTime) {
                long granularity = currTime - lastTime;
                // zapamituj narastajc sum rozdzielczoci
                sum+=granularity;
                count++;
                lastTime = currTime;
            }
        }

        // wywietlenie wynikw
        System.out.println("rednia rozdzielczo zegara " +
            "System.currentTimeMillis(): " + ((float)sum / count));
    }
}
