import java.awt.*;                      // Frame, Graphics, Color, ..
import java.awt.image.*;                // BufferedImage
import java.awt.event.*;                // KeyAdapter, KeyEvent
import java.io.*;                       // File

import javax.swing.JFrame;
import javax.imageio.*;                 // ImageIO

class GrabScreen extends JFrame {

// pola
private BufferedImage screenImage;
private Rectangle screenRect;

// konstruktor
public GrabScreen() {
    setUndecorated(true);

    Dimension screenDims = Toolkit.getDefaultToolkit().getScreenSize();
    screenRect = new Rectangle(0,0, screenDims.width, screenDims.height);

    screenImage = grabScreen(screenRect);

    try {
        ImageIO.write(screenImage, "jpeg", new File("screen.jpg"));
    } catch (Exception ignored) {
        System.out.println("Problem " + ignored);
    }

    saveScreenSnapshotAsThumbnail(  screenRect, new Dimension(160, 120),
                                            "thumb.jpg");

    // zmniejszenie jasnoci rysunku
    darkenImage(screenImage);

    // zakoczenie przez nacinicie klawisza
    addKeyListener(new KeyAdapter() {
        public void keyPressed(KeyEvent e) {
            dispose();
        }
    });

    // pokazanie zrzutu ekranu
    setBounds(screenRect);
    show();
}

/*************************************************************************
 * Przesoniona Component.update()
 *
 * @param g kontekst Graphics do malowania.
 *************************************************************************/
public void update(Graphics g) {
    paint(g);
}

/*************************************************************************
 * Przesoniona Component.paint()
 *
 * @param g kontekst Graphics do malowania.
 *************************************************************************/
public void paint(Graphics g) {

    if ( screenImage != null ) {
        g.drawImage(screenImage, 0,0, null);
    }

}

/*************************************************************************
 * Zmniejszenie intensywnoci BufferedImage
 *************************************************************************/
 public void darkenImage(BufferedImage image) {
    int width = image.getWidth();
    int height= image.getHeight();

    for (int y=0; y < height; y++) {
        for (int x=0; x < width; x++) {
            int color = image.getRGB(x,y);
            color = color >> 1;
            color = color & 0x7F7F7F;
            image.setRGB(x,y, color);
        }
    }

}

/*************************************************************************
 * zapisanie widocznego ekranu
 *
 * @return obiekt BufferedImage zawierajcy okrelony prostokt ekranu
 *************************************************************************/
private BufferedImage grabScreen(Rectangle screenRect) {

    Robot robot = null;
    try {
        robot = new Robot();
    } catch (AWTException awtException) {
        System.out.println(awtException);
        return null;
    }

    BufferedImage screenImage = robot.createScreenCapture(screenRect);

    return screenImage;
}

/*************************************************************************
 * Przechwycenie widzialnego ekranu, zmiana na miniatur 
 * i zapisanie jako JPEG.
 *
 * @param screenRect prostokt definiujcy ekran
 * @param thumbnailDimension wymagany rozmiar miniatury
 * @param thumbnailFilename nazwa pliku wygenerowanej miniatury
 *************************************************************************/
private void saveScreenSnapshotAsThumbnail( Rectangle screenRect,
                                            Dimension thumbnailDimension,
                                            String thumbnailFilename) {

    BufferedImage screenImage = grabScreen(screenRect);

    BufferedImage screenThumbnail = new BufferedImage(
        thumbnailDimension.width,
        thumbnailDimension.height,
        BufferedImage.TYPE_INT_RGB);

    // skalowanie rysunku
    Graphics2D g = screenThumbnail.createGraphics();
    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION,
        RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    g.drawImage(screenImage, 0, 0,
        thumbnailDimension.width,
        thumbnailDimension.height, null);
    g.dispose();

    // zapis do pliku
    try {
        ImageIO.write(screenThumbnail, "jpeg", new File(thumbnailFilename));
    } catch (Exception ignored) {
        System.out.println("Problem " + ignored);
    }
}


//-------------------------------------------------------------------
// main() 
//-------------------------------------------------------------------
public static void main (String[] args) {
    new GrabScreen();
}

}
