package com.brackeen.javagamebook.path;

import java.util.*;

/**
    Klasa AStarSearch class wraz z klas AStarNode, implementuj oglny
    algorytm przeszukiwania A*. Aby umoliwi wykonanie konkretnego
    przeszukiwania, klasa AStarSearch powinna zosta podklasowana.
*/
public class AStarSearch {


    /**
        Prosta lista priorytetw, zwana rwnie kolejk priorytetw.
        Obiekty na tej licie s porzdkowane wedug ich priorytetw,
        ustalanych za pomoc interfejsu Comparable obiektu.
        Element o najwyszym priorytecie znajdzie si na pocztku listy.
    */
    public static class PriorityList extends LinkedList {

        public void add(Comparable object) {
            for (int i=0; i<size(); i++) {
                if (object.compareTo(get(i)) <= 0) {
                    add(i, object);
                    return;
                }
            }
            addLast(object);
        }
    }


    /**
        Skonstruuj ciek, bez wza startowego.
    */
    protected List constructPath(AStarNode node) {
        LinkedList path = new LinkedList();
        while (node.pathParent != null) {
            path.addFirst(node);
            node = node.pathParent;
        }
        return path;
    }


    /**
        Znajd ciek od wza startowego do wza kocowego. Zwracana
        jest lista wzw AStarNode lub warto null, jeli nie uda si 
        odnale cieki.
    */
    public List findPath(AStarNode startNode, AStarNode goalNode) {

        PriorityList openList = new PriorityList();
        LinkedList closedList = new LinkedList();

        startNode.costFromStart = 0;
        startNode.estimatedCostToGoal =
            startNode.getEstimatedCost(goalNode);
        startNode.pathParent = null;
        openList.add(startNode);

        while (!openList.isEmpty()) {
            AStarNode node = (AStarNode)openList.removeFirst();
            if (node == goalNode) {
                // skonstruuj ciek od startu do celu
                return constructPath(goalNode);
            }

            List neighbors = node.getNeighbors();
            for (int i=0; i<neighbors.size(); i++) {
                AStarNode neighborNode =
                    (AStarNode)neighbors.get(i);
                boolean isOpen = openList.contains(neighborNode);
                boolean isClosed =
                    closedList.contains(neighborNode);
                float costFromStart = node.costFromStart +
                    node.getCost(neighborNode);

                // sprawd, czy wze ssiadujcy nie by ju
                // trawersowany lub czy nie zostaa  wanie 
                // znaleziona krtsza cieka do niego.
                if ((!isOpen && !isClosed) ||
                    costFromStart < neighborNode.costFromStart)
                {
                    neighborNode.pathParent = node;
                    neighborNode.costFromStart = costFromStart;
                    neighborNode.estimatedCostToGoal =
                        neighborNode.getEstimatedCost(goalNode);
                    if (isClosed) {
                        closedList.remove(neighborNode);
                    }
                    if (!isOpen) {
                        openList.add(neighborNode);
                    }
                }
            }
            closedList.add(node);
        }

        // nie znaleziono cieki
        return null;
    }

}